@extends('layouts.app')

@section('title', 'Tentang Kami - MAJUIN')

@push('styles')
<style>
    .hero-bg-about {
        background-image: 
            linear-gradient(to right, rgba(17, 24, 39, 0.95), rgba(17, 24, 39, 0.8)),
            url('https://images.pexels.com/photos/5474028/pexels-photo-5474028.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');
        background-size: cover;
        background-position: center center;
    }
</style>
@endpush

@section('content')
    <!-- Hero Section -->
    <section class="hero-bg-about text-white pt-20 pb-20">
        <div class="container mx-auto px-6 text-center" data-aos="fade-up">
            <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-4">Mengenal MAJUIN Lebih Dekat</h1>
            <p class="text-lg text-gray-300 max-w-2xl mx-auto">Kami bukan sekadar penyedia internet wireless, kami adalah mitra digital Anda untuk melesat maju tanpa batas.</p>
        </div>
    </section>

    <!-- Profil Perusahaan -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="flex flex-col lg:flex-row items-center gap-12 lg:gap-16">
                <div class="lg:w-1/2" data-aos="fade-right">
                    <img src="{{ asset('aset/timkami.png') }}" alt="Tim Majuin" class="rounded-xl shadow-2xl w-full">
                </div>
                <div class="lg:w-1/2" data-aos="fade-left">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Cerita di Balik Koneksi Cepat Anda</h2>
                    <p class="text-gray-600 mb-4">MAJUIN lahir dari sebuah gagasan sederhana: semua orang berhak mendapatkan akses internet wireless yang andal dan terjangkau. Kami memulai perjalanan ini didorong oleh semangat untuk memberdayakan masyarakat melalui konektivitas digital di Sukabumi dan sekitarnya.</p>
                    <p class="text-gray-600">Dengan pondasi teknologi wireless terkini, kami hadir sebagai penyedia jasa internet wireless terpercaya yang siap melayani berbagai kebutuhan, mulai dari perumahan hingga korporasi. Kami bangga dapat menjadi bagian dari pertumbuhan digital di wilayah kami dan berkomitmen untuk terus maju bersama Anda.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Peta Jangkauan -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="flex flex-col lg:flex-row items-center gap-12 lg:gap-16">
                <div class="lg:w-1/2" data-aos="fade-right">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Lokasi Kami</h2>
                    <address class="text-gray-600 not-italic mb-6 space-y-2">
                       <p class="font-semibold text-lg text-gray-800">Bumi Mutiara Indah No. D10</p>
                       <p>RT.2/RW.7, Kompa, Parungkuda,</p>
                       <p>Kabupaten Sukabumi, Jawa Barat 43357</p>
                    </address>
                    <a href="https://maps.app.goo.gl/FV9xH1ekdBK5C7Ji6" target="_blank" rel="noopener noreferrer" class="inline-flex items-center gap-2 bg-blue-600 text-white font-semibold px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors shadow-md transform hover:scale-105 mb-8">
                        <i class="fas fa-map-marker-alt"></i>
                        Buka di Google Maps
                    </a>
                     <p class="text-gray-600">Dari sini, tim kami menjangkau berbagai wilayah di sekitar Sukabumi untuk memberikan koneksi internet wireless terbaik.</p>
                </div>
                <div class="lg:w-1/2" data-aos="fade-left">
                    <iframe 
                        width="100%" 
                        height="450" 
                        style="border:0" 
                        loading="lazy" 
                        allowfullscreen 
                        referrerpolicy="no-referrer-when-downgrade" 
                        src="https://maps.google.com/maps?q=-6.818831782528247,106.7586571357641&hl=id&z=16&amp;output=embed"
                        class="rounded-xl shadow-2xl w-full">
                    </iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- Visi & Misi -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Panduan Arah Kami</h2>
                <p class="mt-4 text-lg text-gray-600">Inilah yang menjadi kompas dalam setiap langkah kami.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8 max-w-4xl mx-auto">
                <!-- Visi -->
                <div class="bg-gray-50 p-8 rounded-xl shadow-lg border border-gray-200" data-aos="fade-right">
                    <div class="flex items-center mb-4">
                        <div class="bg-blue-100 text-blue-600 rounded-full p-3 mr-4">
                            <i class="fas fa-eye text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold">Visi Kami</h3>
                    </div>
                    <p class="text-gray-600">Menjadi penyedia layanan internet wireless terdepan yang paling diandalkan oleh masyarakat dan pelaku bisnis untuk mendukung kemajuan digital Indonesia.</p>
                </div>
                <!-- Misi -->
                <div class="bg-gray-50 p-8 rounded-xl shadow-lg border border-gray-200" data-aos="fade-left">
                    <div class="flex items-center mb-4">
                         <div class="bg-green-100 text-green-600 rounded-full p-3 mr-4">
                            <i class="fas fa-bullseye text-2xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold">Misi Kami</h3>
                    </div>
                    <ul class="list-disc list-inside text-gray-600 space-y-2">
                        <li>Menyediakan koneksi internet wireless yang cepat, stabil, dan tanpa batas.</li>
                        <li>Memberikan layanan pelanggan yang responsif dan solutif.</li>
                        <li>Terus berinovasi dalam teknologi jaringan wireless untuk kualitas terbaik.</li>
                        <li>Menawarkan harga yang kompetitif dan transparan.</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Legalitas & Izin Resmi -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="max-w-4xl mx-auto text-center">
                <div data-aos="fade-up">
                    <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Legalitas dan Izin Resmi</h2>
                    <p class="mt-4 text-lg text-gray-600">Kami adalah penyelenggara jasa internet wireless resmi yang beroperasi di bawah naungan hukum dan regulasi yang berlaku di Indonesia.</p>
                </div>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-8 mt-12">
                    <div class="bg-white border border-gray-200 rounded-xl p-6 text-left" data-aos="fade-up" data-aos-delay="100">
                       <div class="flex items-center gap-4">
                           <i class="fas fa-file-contract text-3xl text-blue-500"></i>
                           <div>
                               <h3 class="font-bold text-gray-800">Izin Penyelenggaraan ISP</h3>
                           </div>
                       </div>
                    </div>
                     <div class="bg-white border border-gray-200 rounded-xl p-6 text-left" data-aos="fade-up" data-aos-delay="200">
                       <div class="flex items-center gap-4">
                           <i class="fas fa-tasks text-3xl text-blue-500"></i>
                           <div>
                               <h3 class="font-bold text-gray-800">Surat Keterangan Laik Operasi (SKLO)</h3>
                           </div>
                       </div>
                    </div>
                     <div class="bg-white border border-gray-200 rounded-xl p-6 text-left" data-aos="fade-up" data-aos-delay="300">
                       <div class="flex items-center gap-4">
                           <i class="fas fa-id-card text-3xl text-blue-500"></i>
                           <div>
                               <h3 class="font-bold text-gray-800">Nomor Induk Berusaha (NIB)</h3>
                           </div>
                       </div>
                    </div>
                     <div class="bg-white border border-gray-200 rounded-xl p-6 text-left" data-aos="fade-up" data-aos-delay="400">
                       <div class="flex items-center gap-4">
                           <i class="fas fa-users text-3xl text-blue-500"></i>
                           <div>
                               <h3 class="font-bold text-gray-800">Keanggotaan APJII</h3>
                           </div>
                       </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Nilai-Nilai Perusahaan -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6 text-center">
            <h2 class="text-3xl font-bold text-gray-800 mb-2" data-aos="fade-up">Nilai yang Kami Pegang Teguh</h2>
            <p class="text-gray-500 mb-12 max-w-2xl mx-auto" data-aos="fade-up" data-aos-delay="100">Tiga pilar utama yang membangun budaya kerja dan pelayanan di MAJUIN.</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="p-8" data-aos="fade-up" data-aos-delay="200">
                    <div class="bg-gray-800 text-white rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6 text-3xl">
                        <i class="fas fa-heart"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Pelanggan Utama</h3>
                    <p class="text-gray-600">Kepuasan Anda adalah prioritas kami. Kami mendengarkan dan bertindak untuk memberikan yang terbaik bagi setiap pelanggan.</p>
                </div>
                <div class="p-8" data-aos="fade-up" data-aos-delay="300">
                    <div class="bg-gray-800 text-white rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6 text-3xl">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Integritas</h3>
                    <p class="text-gray-600">Kami bekerja dengan jujur, transparan, dan bertanggung jawab dalam setiap aspek layanan yang kami berikan.</p>
                </div>
                <div class="p-8" data-aos="fade-up" data-aos-delay="400">
                    <div class="bg-gray-800 text-white rounded-full w-20 h-20 flex items-center justify-center mx-auto mb-6 text-3xl">
                        <i class="fas fa-lightbulb"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Inovasi Berkelanjutan</h3>
                    <p class="text-gray-600">Dunia digital terus berubah. Kami berkomitmen untuk terus beradaptasi dan menerapkan teknologi terbaru demi Anda.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Pesan Pendiri -->
    <section class="py-20 bg-blue-600 text-white">
        <div class="container mx-auto px-6">
            <div class="flex flex-col md:flex-row items-center gap-12">
                <div class="md:w-1/3 text-center" data-aos="fade-right">
                    <img src="https://placehold.co/300x300/FFFFFF/3B82F6?text=Foto+Pendiri" alt="Foto Pendiri" class="w-64 h-64 mx-auto rounded-full shadow-2xl border-4 border-white">
                </div>
                <div class="md:w-2/3" data-aos="fade-left">
                    <h2 class="text-3xl font-bold mb-4">Sepatah Kata dari Pendiri Kami</h2>
                    <blockquote class="border-l-4 border-blue-300 pl-6 italic text-lg text-blue-100">
                        "Visi kami di MAJUIN adalah membangun jembatan digital yang menghubungkan setiap individu dengan peluang tak terbatas. Kami percaya bahwa koneksi internet wireless yang andal bukanlah sebuah kemewahan, melainkan hak untuk maju bersama di era digital ini. Terima kasih telah mempercayai kami untuk menjadi bagian dari perjalanan Anda."
                    </blockquote>
                    <p class="mt-6 font-bold text-xl">Jajuli</p>
                    <p class="text-blue-200">direktur</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Tim Kami -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Tim Kami</h2>
                <p class="mt-4 text-lg text-gray-600 max-w-2xl mx-auto">
                    Kenali para profesional yang berdedikasi untuk memberikan Anda koneksi internet wireless terbaik.
                </p>
            </div>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-5 mt-12 gap-10 items-start lg:items-center">
                <div class="text-center" data-aos="fade-up" data-aos-delay="100">
                    <img
                        src="https://placehold.co/192x192/EBF4FF/3B82F6?text=Foto"
                        alt="Nama Anggota Tim"
                        class="w-48 h-48 mx-auto rounded-full shadow-lg mb-4 object-cover"
                    >
                    <h3 class="text-xl font-bold text-gray-800">Muhamad Rizal Ripaldi</h3>
                    <p class="text-blue-600 font-medium">Manager</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="200">
                    <img
                        src="https://placehold.co/300x300/EBF4FF/3B82F6?text=Foto"
                        alt="Nama Anggota Tim"
                        class="w-48 h-48 mx-auto rounded-full shadow-lg mb-4"
                    >
                    <h3 class="text-xl font-bold text-gray-800">Muhammad Tubagus Ridwan</h3>
                    <p class="text-blue-600 font-medium">Engineer</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="300">
                    <img
                        src="https://placehold.co/300x300/EBF4FF/3B82F6?text=Foto"
                        alt="Nama Anggota Tim"
                        class="w-48 h-48 mx-auto rounded-full shadow-lg mb-4"
                    >
                    <h3 class="text-xl font-bold text-gray-800">Muhamad Paridudin</h3>
                    <p class="text-blue-600 font-medium">Engineer</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="400">
                    <img
                        src="https://placehold.co/300x300/EBF4FF/3B82F6?text=Foto"
                        alt="Nama Anggota Tim"
                        class="w-48 h-48 mx-auto rounded-full shadow-lg mb-4"
                    >
                    <h3 class="text-xl font-bold text-gray-800">Amiruloh</h3>
                    <p class="text-blue-600 font-medium">Customer Serive</p>
                </div>
                <div class="text-center" data-aos="fade-up" data-aos-delay="500">
                    <img
                        src="https://placehold.co/300x300/EBF4FF/3B82F6?text=Foto"
                        alt="Nama Anggota Tim"
                        class="w-48 h-48 mx-auto rounded-full shadow-lg mb-4"
                    >
                    <h3 class="text-xl font-bold text-gray-800">Ilham Permana</h3>
                    <p class="text-blue-600 font-medium">Network Operation Center</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Final CTA -->
    <section class="bg-slate-900 text-white">
        <div class="container mx-auto px-6 py-20 text-center">
            <h2 class="text-4xl font-bold mb-6" data-aos="fade-up">Siap Menjadi Bagian dari Cerita Kami?</h2>
            <a href="{{ url('/layanan') }}" class="bg-blue-600 text-white font-bold px-8 py-3 rounded-lg hover:bg-blue-700 transition-colors relative transform hover:scale-105" data-aos="fade-up" data-aos-delay="100">
                Lihat Paket Internet Wireless
            </a>
        </div>
    </section>
@endsection
