<?php $__env->startSection('title', 'Layanan Internet Wireless - MAJUIN'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .hero-bg-services {
        background-image: 
            linear-gradient(to right, rgba(17, 24, 39, 0.95), rgba(17, 24, 39, 0.8)),
            url('https://images.pexels.com/photos/39284/macbook-apple-imac-computer-39284.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1');
        background-size: cover;
        background-position: center center;
    }
    .service-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        border-color: #3B82F6;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="hero-bg-services text-white pt-20 pb-20">
        <div class="container mx-auto px-6 text-center" data-aos="fade-up">
            <h1 class="text-4xl md:text-5xl font-extrabold leading-tight mb-4">Solusi Internet Wireless untuk Semua</h1>
            <p class="text-lg text-gray-300 max-w-2xl mx-auto">Dari kebutuhan harian di rumah hingga operasional bisnis yang krusial, temukan paket internet wireless yang paling tepat untuk Anda.</p>
        </div>
    </section>

    <!-- Perbandingan Layanan -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pilih Solusi yang Tepat untuk Anda</h2>
                <p class="mt-4 text-lg text-gray-600">Kami menyediakan dua jenis layanan utama yang disesuaikan dengan kebutuhan Anda.</p>
            </div>
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-10 max-w-5xl mx-auto" data-aos="fade-up" data-aos-delay="100">
                <!-- Kartu Broadband -->
                <div class="border-2 border-gray-200 rounded-xl p-8">
                    <h3 class="text-2xl font-bold text-center text-blue-600 mb-6">Broadband Wireless</h3>
                    <ul class="space-y-4">
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Keunggulan</span>
                            <span class="text-gray-600 text-right font-medium">Harga Terjangkau & Fleksibel</span>
                        </li>
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Alokasi Bandwidth</span>
                            <span class="text-gray-600 text-right">Optimal untuk Keseharian</span>
                        </li>
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Performa</span>
                            <span class="text-gray-600 text-right">Koneksi Andal & Stabil</span>
                        </li>
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Dukungan Teknis</span>
                            <span class="text-gray-600 text-right">Dukungan Teknis 24/7</span>
                        </li>
                        <li class="flex justify-between items-center">
                            <span class="font-semibold">Rekomendasi</span>
                            <span class="text-gray-600 text-right">Streaming, Belajar, WFH</span>
                        </li>
                    </ul>
                </div>
                <!-- Kartu Dedicated -->
                <div class="border-2 border-blue-600 rounded-xl p-8 bg-blue-50 relative">
                     <p class="absolute top-0 -translate-y-1/2 bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full">Untuk Bisnis</p>
                    <h3 class="text-2xl font-bold text-center text-blue-600 mb-6">Dedicated Wireless</h3>
                    <ul class="space-y-4">
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Keunggulan</span>
                            <span class="text-green-600 text-right font-medium">Performa & Stabilitas Maksimal</span>
                        </li>
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Alokasi Bandwidth</span>
                            <span class="text-gray-600 text-right">Eksklusif (Rasio 1:1)</span>
                        </li>
                        <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Jaminan Layanan</span>
                            <span class="text-gray-600 text-right">Jaminan Uptime 99% (SLA)</span>
                        </li>
                         <li class="flex justify-between items-center border-b pb-3">
                            <span class="font-semibold">Dukungan Teknis</span>
                            <span class="text-green-600 text-right font-medium">Layanan Prioritas 24/7</span>
                        </li>
                        <li class="flex justify-between items-center">
                            <span class="font-semibold">Rekomendasi</span>
                            <span class="text-gray-600 text-right">Server, VPN, Operasional Kritis</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Detail Paket Broadband -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Paket Broadband Wireless</h2>
                <p class="mt-4 text-lg text-gray-600">Pilih kecepatan yang sesuai dengan kebutuhan digital keluarga Anda.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Paket 1 -->
                <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="100">
                    <h3 class="text-2xl font-bold mb-2">Spark</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">10 <span class="text-xl font-medium">Mbps</span></p>
                    <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                        <li class="flex items-center"><i class="fas fa-users text-blue-500 mr-3"></i>Ideal untuk 1-3 orang</li>
                        <li class="flex items-center"><i class="fas fa-film text-blue-500 mr-3"></i>Streaming Kualitas HD</li>
                        <li class="flex items-center"><i class="fas fa-globe text-blue-500 mr-3"></i>Browsing & Sosmed</li>
                        <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Spark%2010%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                </div>
                 <!-- Paket 2 -->
                <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="200">
                    <h3 class="text-2xl font-bold mb-2">Boost</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">15 <span class="text-xl font-medium">Mbps</span></p>
                    <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                        <li class="flex items-center"><i class="fas fa-users text-blue-500 mr-3"></i>Ideal untuk 3-5 orang</li>
                        <li class="flex items-center"><i class="fas fa-video text-blue-500 mr-3"></i>Video Conference</li>
                         <li class="flex items-center"><i class="fas fa-gamepad text-blue-500 mr-3"></i>Game Online Ringan</li>
                         <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Boost%2015%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                </div>
                 <!-- Paket 3 -->
                <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col border-2 border-blue-600 transform lg:scale-105 relative" data-aos="fade-up" data-aos-delay="300">
                     <p class="absolute top-0 right-1/2 translate-x-1/2 -translate-y-1/2 bg-blue-600 text-white text-xs font-bold px-3 py-1 rounded-full">Paling Populer</p>
                    <h3 class="text-2xl font-bold mb-2">Turbo</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">20 <span class="text-xl font-medium">Mbps</span></p>
                    <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                       <li class="flex items-center"><i class="fas fa-users text-blue-500 mr-3"></i>Keluarga Besar</li>
                       <li class="flex items-center"><i class="fas fa-tv text-blue-500 mr-3"></i>Streaming 4K</li>
                       <li class="flex items-center"><i class="fas fa-cloud-upload-alt text-blue-500 mr-3"></i>Upload Konten</li>
                       <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Turbo%2020%20Mbps." class="w-full mt-auto text-center bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition-colors">Pilih Paket</a>
                </div>
                 <!-- Paket 4 -->
                <div class="bg-white rounded-xl shadow-lg p-8 text-center flex flex-col transition-all duration-300 hover:shadow-2xl hover:scale-105" data-aos="fade-up" data-aos-delay="400">
                    <h3 class="text-2xl font-bold mb-2">Velocity</h3>
                    <p class="text-5xl font-extrabold text-blue-600 my-3">30 <span class="text-xl font-medium">Mbps</span></p>
                    <ul class="space-y-3 text-gray-600 mb-8 flex-grow text-left">
                         <li class="flex items-center"><i class="fas fa-broadcast-tower text-blue-500 mr-3"></i>Kebutuhan Tinggi</li>
                         <li class="flex items-center"><i class="fas fa-gamepad text-blue-500 mr-3"></i>Game Online Berat</li>
                         <li class="flex items-center"><i class="fas fa-server text-blue-500 mr-3"></i>Multiple Streaming 4K</li>
                         <li class="flex items-center"><i class="fas fa-headset text-blue-500 mr-3"></i>Dukungan Teknis 24/7</li>
                    </ul>
                    <a href="https://wa.me/62817228297?text=Halo,%20saya%20tertarik%20untuk%20berlangganan%20paket%20Velocity%2030%20Mbps." class="w-full mt-auto text-center bg-blue-100 text-blue-700 font-bold py-3 rounded-lg hover:bg-blue-200 transition-colors">Pilih Paket</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Detail Layanan Dedicated -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
             <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Solusi Dedicated Wireless untuk Bisnis</h2>
                <p class="mt-4 text-lg text-gray-600 max-w-3xl mx-auto">Layanan premium yang dirancang khusus untuk menjamin kelancaran dan keamanan operasional bisnis Anda yang paling kritis.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <div class="bg-gray-50 p-8 rounded-xl" data-aos="fade-up" data-aos-delay="100">
                    <i class="fas fa-exchange-alt text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Bandwidth Simetris 1:1</h3>
                    <p class="text-gray-600">Kecepatan download dan upload yang sama persis dan tidak terbagi. Ideal untuk video conference, transfer file besar, dan server internal.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl" data-aos="fade-up" data-aos-delay="200">
                    <i class="fas fa-shield-alt text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Jaminan Uptime 99% (SLA)</h3>
                    <p class="text-gray-600">Kami memberikan jaminan konektivitas melalui Service Level Agreement, memastikan bisnis Anda selalu online dan produktif.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl" data-aos="fade-up" data-aos-delay="300">
                    <i class="fas fa-globe-asia text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">IP Publik Statis</h3>
                    <p class="text-gray-600">Dapatkan alamat IP khusus untuk kebutuhan server, VPN, atau sistem lain yang memerlukan akses dari luar jaringan kantor Anda.</p>
                </div>
            </div>
            <div class="text-center mt-12" data-aos="fade-up" data-aos-delay="400">
                 <a href="#" class="bg-blue-600 text-white font-bold px-8 py-4 rounded-lg hover:bg-blue-700 transition-colors transform hover:scale-105 shadow-lg inline-block">
                    Diskusikan Kebutuhan Bisnis Anda
                </a>
            </div>
        </div>
    </section>

    <!-- Langkah Pemasangan -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Langkah Mudah Pemasangan</h2>
                <p class="mt-4 text-lg text-gray-600 max-w-2xl mx-auto">Dapatkan koneksi internet wireless cepat di tempat Anda hanya dengan 3 langkah mudah.</p>
            </div>
            <div class="flex flex-col md:flex-row items-start justify-center gap-8 md:gap-4 text-center" data-aos="fade-up" data-aos-delay="100">
                <div class="flex flex-col items-center">
                    <div class="bg-blue-100 rounded-full p-6 mb-4">
                         <i class="fas fa-phone-volume text-4xl text-blue-600"></i>
                    </div>
                    <h3 class="font-bold text-xl mb-2">1. Hubungi & Konsultasi</h3>
                    <p class="text-gray-600 max-w-xs">Hubungi tim kami via WhatsApp atau telepon untuk konsultasi kebutuhan dan pengecekan jangkauan awal.</p>
                </div>
                <div class="text-gray-300 text-4xl mx-4 mt-8 hidden md:block">&rarr;</div>
                <div class="text-gray-300 text-4xl my-4 md:hidden">&darr;</div>
                <div class="flex flex-col items-center">
                    <div class="bg-blue-100 rounded-full p-6 mb-4">
                         <i class="fas fa-map-marked-alt text-4xl text-blue-600"></i>
                    </div>
                    <h3 class="font-bold text-xl mb-2">2. Survey & Jadwal</h3>
                    <p class="text-gray-600 max-w-xs">Tim kami akan melakukan survey gratis ke lokasi Anda dan menentukan jadwal instalasi yang paling sesuai.</p>
                </div>
                 <div class="text-gray-300 text-4xl mx-4 mt-8 hidden md:block">&rarr;</div>
                 <div class="text-gray-300 text-4xl my-4 md:hidden">&darr;</div>
                <div class="flex flex-col items-center">
                    <div class="bg-blue-100 rounded-full p-6 mb-4">
                         <i class="fas fa-tools text-4xl text-blue-600"></i>
                    </div>
                    <h3 class="font-bold text-xl mb-2">3. Instalasi & Aktivasi</h3>
                    <p class="text-gray-600 max-w-xs">Teknisi profesional kami akan memasang perangkat dan mengaktifkan koneksi internet Anda hingga siap digunakan.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Komitmen Layanan Kami -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Komitmen Layanan Kami</h2>
                <p class="mt-4 text-lg text-gray-600">Inilah jaminan yang kami berikan kepada setiap pelanggan MAJUIN.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-5xl mx-auto">
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="100">
                    <i class="fas fa-signal text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Jaringan Stabil & Andal</h3>
                    <p class="text-gray-600">Kami menggunakan teknologi terbaik untuk memastikan koneksi internet Anda tetap stabil, bahkan di jam sibuk sekalipun.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="200">
                    <i class="fas fa-headset text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Dukungan Cepat Tanggap</h3>
                    <p class="text-gray-600">Tim support kami selalu siap membantu Anda 24/7 melalui berbagai kanal untuk menyelesaikan setiap kendala dengan cepat.</p>
                </div>
                <div class="bg-gray-50 p-8 rounded-xl text-center" data-aos="fade-up" data-aos-delay="300">
                    <i class="fas fa-file-invoice-dollar text-4xl text-blue-600 mb-4"></i>
                    <h3 class="text-xl font-bold mb-2">Transparansi Biaya</h3>
                    <p class="text-gray-600">Tidak ada biaya tersembunyi. Anda hanya membayar sesuai paket yang Anda pilih, dengan rincian yang jelas dan transparan.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Q&A Section -->
    <section class="py-20 bg-gray-50 dot-pattern">
        <div class="container mx-auto px-6">
            <div class="text-center mb-12" data-aos="fade-up">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900">Pertanyaan Umum Seputar Layanan</h2>
            </div>
            <div class="max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="100">
                <div class="space-y-4">
                    <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                        <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                            <span class="text-lg">Apakah cuaca buruk memengaruhi koneksi?</span>
                            <i class="fas fa-plus text-blue-600"></i>
                        </button>
                        <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                            <div class="p-6 pt-0 text-gray-600">
                                <p>Teknologi wireless modern yang kami gunakan sudah sangat tahan terhadap kondisi cuaca. Hujan ringan atau mendung umumnya tidak akan berpengaruh. Koneksi mungkin mengalami sedikit penurunan performa hanya jika terjadi cuaca ekstrem seperti badai petir yang sangat lebat.</p>
                            </div>
                        </div>
                    </div>
                    <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                        <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                            <span class="text-lg">Berapa lama proses instalasi?</span>
                             <i class="fas fa-plus text-blue-600"></i>
                        </button>
                        <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                            <div class="p-6 pt-0 text-gray-600">
                                <p>Setelah survey lokasi Anda disetujui, proses instalasi biasanya hanya memakan waktu 2-4 jam. Tim teknisi kami akan memasang antena, menarik kabel, dan mengkonfigurasi router hingga internet Anda aktif dan siap digunakan.</p>
                            </div>
                        </div>
                    </div>
                    <div class="qa-item bg-white rounded-lg shadow-md border border-gray-200 overflow-hidden">
                        <button class="qa-question w-full text-left flex justify-between items-center p-6 font-semibold text-gray-800 focus:outline-none">
                            <span class="text-lg">Perangkat apa saja yang saya dapatkan?</span>
                             <i class="fas fa-plus text-blue-600"></i>
                        </button>
                        <div class="qa-answer max-h-0 overflow-hidden transition-all duration-500 ease-in-out">
                            <div class="p-6 pt-0 text-gray-600">
                                <p>Kami meminjamkan semua perangkat yang dibutuhkan selama Anda berlangganan, yang meliputi:</p>
                                 <ul class="list-disc list-inside mt-2 space-y-1">
                                    <li>Antena Penerima Outdoor</li>
                                    <li>Kabel Jaringan</li>
                                    <li>Router WiFi Indoor</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const qaItems = document.querySelectorAll('.qa-item');
        qaItems.forEach(item => {
            const question = item.querySelector('.qa-question');
            const answer = item.querySelector('.qa-answer');
            const icon = question.querySelector('i');

            question.addEventListener('click', () => {
                const isOpen = answer.style.maxHeight && answer.style.maxHeight !== '0px';

                qaItems.forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.querySelector('.qa-answer').style.maxHeight = '0px';
                        const otherIcon = otherItem.querySelector('.qa-question i');
                        otherIcon.classList.remove('fa-minus');
                        otherIcon.classList.add('fa-plus');
                    }
                });

                if (isOpen) {
                    answer.style.maxHeight = '0px';
                    icon.classList.remove('fa-minus');
                    icon.classList.add('fa-plus');
                } else {
                    answer.style.maxHeight = answer.scrollHeight + 'px';
                    icon.classList.remove('fa-plus');
                    icon.classList.add('fa-minus');
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/lab-mji/Pictures/new/mji_isp/resources/views/layanan.blade.php ENDPATH**/ ?>